<?php foreach ($args['posts'] as $testimonial) { ?>
	<?php if ( isset( $testimonial['testimonial'] ) ) { ?>
		<div class="container1 content2 two-cols testimonial-id-<?php echo $testimonial['id']; ?>" itemscope itemtype="http://schema.org/Review">
			<div itemprop="itemReviewed" itemscope itemtype="http://schema.org/Organization">
				<meta itemprop="name" content="<?php bloginfo( 'name' ); ?>" />
				<meta itemprop="url" content="<?php bloginfo( 'url' ); ?>" />
			</div>		
			<?php if ( isset( $testimonial['title'] ) && $args['show_title'] == 1 ) { ?>
				<h4 itemprop="name"><?php echo $testimonial['title']; ?></h4>
			<?php } ?>
			<div class="container1-right">
				
				<?php if ( !empty( $args['show_image'] ) ) { ?>
					<?php if ( isset( $testimonial['image'] ) ) { ?>
						<img src="<?php echo $testimonial['image']; ?>" style="border-radius: 50%;" alt="">
					<?php } ?>
				<?php } ?>
			
				<div class="author_wrap" itemprop="author" itemscope itemtype="http://schema.org/Person">
			
				<?php if ( !empty( $testimonial['name'] ) ) { ?>
					<div class="author-name" itemprop="name"><?php echo $testimonial['name']; ?></div>
				<?php } ?>
				<?php if ( !empty( $testimonial['position'] ) && !empty( $args['show_position'] ) ) { ?>
					<?php if ( !empty( $testimonial['link'] ) ) { ?>
						<div class="author-work" itemprop="jobTitle"><a href="<?php echo $testimonial['link']; ?>" itemprop="url" target="_blank" rel="nofollow"><?php echo $testimonial['position']; ?></a></div>
					<?php } else { ?>
						<div class="author-work" itemprop="jobTitle"><?php echo $testimonial['position']; ?></div>
					<?php } ?>
				<?php } ?>
							
				</div>
				<?php if ( !empty( $args['show_rating'] ) && !empty( $testimonial['rating'] ) ) { ?>
					<div class="rating" itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating">
						<span class="value-title" title="<?php echo $testimonial['rating']; ?>"></span> 
						<?php echo mts_testimonials_get_rating_html( $testimonial['rating'] ); ?>
						<meta itemprop="ratingValue" content="<?php echo $testimonial['rating']; ?>" />
					</div>
				<?php } ?>	
			</div>
			<p class="quotes" itemprop="reviewBody">
				<svg style=" margin-right: 2px; position: relative; top: 4px;" enable-background="new 0 0 500 500" height="32px" id="Layer_1" version="1.1" viewBox="0 0 500 500" width="32px" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path clip-rule="evenodd" d="M36.992,416.569c0,20.078,16.262,36.344,36.34,36.344h118.111  c20.079,0,36.343-16.266,36.343-36.344V271.202c0-20.079-16.264-36.342-36.343-36.342h-58.328c-10.089,0-18.17-8.177-18.17-18.17  c0-3.271,0.815-5.542,0.815-5.542c13.264-43.977,46.785-79.227,89.762-94.852l0.18-0.182c12.997-5.54,22.083-18.445,22.083-33.437  c0-20.077-16.264-36.341-36.343-36.341c-4.906,0-9.536,0.998-13.804,2.723l-1.644,0.64C94.68,81.405,36.992,160.45,36.992,253.03  V416.569z M273.215,416.569c0,20.078,16.262,36.344,36.341,36.344h118.112c20.078,0,36.34-16.266,36.34-36.344V271.202  c0-20.079-16.262-36.342-36.34-36.342h-58.33c-10.088,0-18.169-8.177-18.169-18.17c0-3.362,0.813-5.542,0.813-5.542  c13.267-43.977,46.787-79.227,89.765-94.852l0.18-0.182c12.995-5.54,22.081-18.445,22.081-33.437  c0-20.077-16.262-36.341-36.34-36.341c-4.906,0-9.538,0.998-13.805,2.723l-1.644,0.64C330.903,81.405,273.215,160.45,273.215,253.03  V416.569z" fill="#d8d8d8" fill-rule="evenodd"/></svg>
				<?php echo $testimonial['testimonial']; ?>
			</p>		
		</div>
	<?php } ?>
<?php } ?>